package gov.va.vinci.dart.json.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.json.GroupListView;
import gov.va.vinci.dart.json.GroupView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestGroupListViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		Group.initialize();
	}

	@Test
	public void testOne() throws Exception {
		GroupListViewBuilder builder = SingletonShim.getBean(GroupListViewBuilder.class);
		
		try {
			builder.build((Collection<Group>)null, true);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		List<Group> groupList = new ArrayList<Group>();
		
		GroupListView glv = builder.build(groupList, true);
		Assert.assertNotNull(glv);
		Assert.assertNotNull(glv.getGroups());
		Assert.assertEquals(glv.getGroups().size(), 0);
		
		Group group = DartObjectFactory.getInstance().getGroupDAO().findById(1);
		
		groupList.add(group);
		
		glv = builder.build(groupList, true);
		Assert.assertNotNull(glv);
		Assert.assertNotNull(glv.getGroups());
		Assert.assertEquals(glv.getGroups().size(), 1);
		
		GroupView gv = glv.getGroups().get(0);
		Assert.assertNotNull(gv);
		Assert.assertEquals(gv.getId(), 1);
		Assert.assertEquals(gv.getName(), group.getName());
	}
	
}
